import pickle
import zipfile

def convert_params(params):
    new_params = dict()
    for k, v in params.items():
        k = k.replace("wf/orbitals/generalized_atomic_orbitals", "wf/~/orbitals/~/generalized_atomic_orbitals")
        new_params[k] = v
    return new_params

def convert_checkpoint(fname_in, fname_out):
    zf_in = zipfile.ZipFile(fname_in, "r", zipfile.ZIP_BZIP2)
    zf_out = zipfile.ZipFile(fname_out, "a", zipfile.ZIP_BZIP2)
    for item in zf_in.infolist():
        if item.filename == "opt_state.pkl":
            continue
        elif item.filename == "params.pkl":
            with zf_in.open(item.filename, "r") as f:
                params = pickle.load(f)
            params = convert_params(params)
            with zf_out.open(item.filename, "w") as f:
                pickle.dump(params, f)
        else:
            buffer = zf_in.read(item.filename)
            zf_out.writestr(item, buffer)
    zf_in.close()
    zf_out.close()



