<!--
https://github.com/paperswithcode/releasing-research-code/blob/master/templates/README.md
-->

# Optimal Estimation of the Best Mean in Multi-Armed Bandits

This repository is the official implementation of "Optimal Estimation of the Best Mean in Multi-Armed Bandits". 

## Requirements

We set up the environment with poetry.  To install requirements where python is available (e.g., creating an environment with `pyenv local 3.12.9`):

```setup
poetry install
```

## Run experiments

Change the directory by
```
cd exp/neurips2025/
```

Run a sample code by
```
poetry run python run-sample.py
```

Use `run` from `tools.py` for an arbitrary setting:
```
from tools import run

algorithm = "ellipsoid"    # select from ["ellipsoid", "SE", "UGapEc"]
instance = "equal"         # select from ["equal", "single", "bell"]
epsilon = 0.1
delta = 0.1
n_arms = 10                # the number of arms
seed = 42                  # random number seed
distribution = "Bernoulli" # select from ["Bernoulli", "Gaussian"]
R = 0.5
S = 0.5

run(algorithm, instance, epsilon, delta, n_arms, seed, distribution=distribution, R=R, S=S)
```
Here, `algorithm` should be either "ellipsoid" (ElipsoidEst), "SE" (Successive Elimination), or "UGapEc" (UGapEc); `instance` should be either "equal" (Uniform), "single" (Clustered), or "bell" (Gaussian).

