import argparse
from tools import run


if __name__ == "__main__":

    parser = argparse.ArgumentParser(description='run MAB algorithm')
    parser.add_argument('algorithm', type=str)
    parser.add_argument('instance', type=str)
    parser.add_argument('epsilon', type=float)
    parser.add_argument("delta", type=float)
    parser.add_argument("n_arms", type=int)
    parser.add_argument("seed", type=int)
    parser.add_argument("-reg", "--reg", type=float, default=None)
    parser.add_argument("--R", type=float, default=0.5)
    parser.add_argument("--S", type=float, default=1.0)
    parser.add_argument("--rerun", action='store_true')
    args = parser.parse_args()

    run(args.algorithm, args.instance, args.epsilon, args.delta, args.n_arms, args.seed, reg=args.reg, R=args.R, S=args.S, rerun=args.rerun)
