# Long Range Modulation Networks (LRMs)
Here we include our PyTorch implementation of LRM Networks. The LRMNet class is a wrapper that can be used to add modulatory feedback between any two layers of any CNN model. We have a separate implementation for vision transformers (lrmvit, not included), as these require architecture-specific adjustments.

e.g.,
```
from .models import LRMNet
from torchvision.models import alexnet

backbone = alexnet()

# Feedback is specified as a tuple with a 'target_layer' and list of [source_layers]
# - features.8 recieves feedback from classifier.6
# - features.0 receives feedback from features.9

mod_connections = [ 
    ('features.8', ['classifier.6']),
    ('features.0', ['features.9']),
]

# create the model with default number of forward passes (time_steps) and expected img_size
# - number of forward passes can be specified in forward pass
# - actual input img_size can be any size and LRMNet will adapt feedback size automatically
model = LRMNet(backbone, mod_connections, time_steps=2, img_size=224)
```

```
LRMNet(
  (backbone): AlexNet(
    (features): Sequential(
      (0): Conv2d(3, 64, kernel_size=(11, 11), stride=(4, 4), padding=(2, 2))
      (1): ReLU(inplace=True)
      (2): MaxPool2d(kernel_size=3, stride=2, padding=0, dilation=1, ceil_mode=False)
      (3): Conv2d(64, 192, kernel_size=(5, 5), stride=(1, 1), padding=(2, 2))
      (4): ReLU(inplace=True)
      (5): MaxPool2d(kernel_size=3, stride=2, padding=0, dilation=1, ceil_mode=False)
      (6): Conv2d(192, 384, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
      (7): ReLU(inplace=True)
      (8): Conv2d(384, 256, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
      (9): ReLU(inplace=True)
      (10): Conv2d(256, 256, kernel_size=(3, 3), stride=(1, 1), padding=(1, 1))
      (11): ReLU(inplace=True)
      (12): MaxPool2d(kernel_size=3, stride=2, padding=0, dilation=1, ceil_mode=False)
    )
    (avgpool): AdaptiveAvgPool2d(output_size=(6, 6))
    (classifier): Sequential(
      (0): Dropout(p=0.5, inplace=False)
      (1): Linear(in_features=9216, out_features=4096, bias=True)
      (2): ReLU(inplace=True)
      (3): Dropout(p=0.5, inplace=False)
      (4): Linear(in_features=4096, out_features=4096, bias=True)
      (5): ReLU(inplace=True)
      (6): Linear(in_features=4096, out_features=1000, bias=True)
    )
  )
  (lrm): Sequential(
    (features8_modulation): LongRangeModulation(
      (from_classifier_6_to_features_8): ModBlock(
        (rescale): NormSquashResize(
          (norm): ChannelNorm((1000,), eps=1e-05, elementwise_affine=True)
          (squash): FeedbackScale(mode='tanh')
          (interp): AddSpatialDimension()
        )
        (modulation): Conv2d(1000, 256, kernel_size=(1, 1), stride=(1, 1))
      )
    )
    (features0_modulation): LongRangeModulation(
      (from_features_9_to_features_0): ModBlock(
        (rescale): NormSquashResize(
          (norm): AdaptiveFullstackNorm((256, 55, 55), eps=1e-05, elementwise_affine=True)
          (squash): FeedbackScale(mode='tanh')
          (interp): AdaptiveUpsample(upsample_mode='UpsampleBilinear')
        )
        (modulation): Conv2d(256, 64, kernel_size=(1, 1), stride=(1, 1))
      )
    )
  )
)
```