from __future__ import print_function, division
import math
import gc

import torch
import torch.nn as nn
import torch.nn.functional as F
import torch.utils.data
from torch.distributions.categorical import Categorical

from .shared import conv_block, up_conv


class UNetScale(nn.Module):

    def __init__(self, in_ch=3, num_classes=1):
        super().__init__()

        n1 = 64
        filters = [n1, n1 * 2, n1 * 4, n1 * 8, n1 * 16]

        self.Maxpool1 = nn.MaxPool2d(kernel_size=2, stride=2)
        self.Maxpool2 = nn.MaxPool2d(kernel_size=2, stride=2)
        self.Maxpool3 = nn.MaxPool2d(kernel_size=2, stride=2)
        self.Maxpool4 = nn.MaxPool2d(kernel_size=2, stride=2)

        self.Conv1 = conv_block(in_ch, filters[0])
        self.Conv2 = conv_block(filters[0], filters[1])
        self.Conv3 = conv_block(filters[1], filters[2])
        self.Conv4 = conv_block(filters[2], filters[3])
        self.Conv5 = conv_block(filters[3], filters[4])

        self.Up5 = up_conv(filters[4], filters[3])
        self.Up_conv5 = conv_block(filters[4], filters[3])

        self.Up4 = up_conv(filters[3], filters[2])
        self.Up_conv4 = conv_block(filters[3], filters[2])

        self.Up3 = up_conv(filters[2], filters[1])
        self.Up_conv3 = conv_block(filters[2], filters[1])

        self.Up2 = up_conv(filters[1], filters[0])
        self.Up_conv2 = conv_block(filters[1], filters[0])

        self.Pred5 = nn.Sequential(
            conv_block(filters[4], filters[0]),
            nn.Conv2d(filters[0], num_classes,
                      kernel_size=1, stride=1, padding=0),
            )
        self.Pred4 = nn.Sequential(
            conv_block(filters[3], filters[0]),
            nn.Conv2d(filters[0], num_classes,
                      kernel_size=1, stride=1, padding=0),
            )
        self.Pred3 = nn.Sequential(
            conv_block(filters[2], filters[0]),
            nn.Conv2d(filters[0], num_classes,
                      kernel_size=1, stride=1, padding=0),
            )
        self.Pred2 = nn.Sequential(
            conv_block(filters[1], filters[0]),
            nn.Conv2d(filters[0], num_classes,
                      kernel_size=1, stride=1, padding=0),
            )
        self.Pred1 = nn.Sequential(
            conv_block(filters[0], filters[0]),
            nn.Conv2d(filters[0], num_classes,
                      kernel_size=1, stride=1, padding=0),
            )
        # self.active = torch.nn.Softmax(dim=1)

    def forward(self, x):
        e1 = self.Conv1(x)

        e2 = self.Maxpool1(e1)
        e2 = self.Conv2(e2)

        e3 = self.Maxpool2(e2)
        e3 = self.Conv3(e3)

        e4 = self.Maxpool3(e3)
        e4 = self.Conv4(e4)

        e5 = self.Maxpool4(e4)
        e5 = self.Conv5(e5)

        sig = 5

        pred5 = self.Pred5(e5)
        c = F.interpolate(pred5.softmax(dim=1), scale_factor=2, mode='bilinear', align_corners=True)
        c = c.topk(k=2, dim=1)[0]  # certainty
        c = (c[:, 0:1, :, :] - 0.5).clamp(min=0)
        # c = (c[:, 0, :, :] - c[:, 1, :, :]).unsqueeze(dim=1)
        # c = ((c - 0.5) * sig).sigmoid()
        # c = 1 - Categorical(probs=pred5.softmax(dim=1).permute(0,2,3,1)[:, :, :, 1:5]).entropy().unsqueeze(dim=1) / 1.387  # B, 1, H, W
        d5 = self.Up5(e5)
        d5 = torch.cat((e4 * (2 - c), d5 * (1 + c)), dim=1)
        d5 = self.Up_conv5(d5)

        pred4 = self.Pred4(d5)
        c = F.interpolate(pred4.softmax(dim=1), scale_factor=2, mode='bilinear', align_corners=True)
        c = c.topk(k=2, dim=1)[0]  # ce
        c = (c[:, 0:1, :, :] - 0.5).clamp(min=0)
        # c = (c[:, 0, :, :] - c[:, 1, :, :]).unsqueeze(dim=1)
        # c = ((c - 0.5) * sig).sigmoid()
        # c = 1 - Categorical(probs=pred5.softmax(dim=1).permute(0,2,3,1)[:, :, :, 1:5]).entropy().unsqueeze(dim=1) / 1.387  # B, 1, H, W
        d4 = self.Up4(d5)
        d4 = torch.cat((e3 * (2 - c), d4 * (1 + c)), dim=1)
        d4 = self.Up_conv4(d4)

        pred3 = self.Pred3(d4)
        c = F.interpolate(pred3.softmax(dim=1), scale_factor=2, mode='bilinear', align_corners=True)
        c = c.topk(k=2, dim=1)[0]  # ce
        c = (c[:, 0:1, :, :] - 0.5).clamp(min=0)
        # c = (c[:, 0, :, :] - c[:, 1, :, :]).unsqueeze(dim=1)
        # c = ((c - 0.5) * sig).sigmoid()
        # c = 1 - Categorical(probs=pred5.softmax(dim=1).permute(0,2,3,1)[:, :, :, 1:5]).entropy().unsqueeze(dim=1) / 1.387  # B, 1, H, W
        d3 = self.Up3(d4)
        d3 = torch.cat((e2 * (2 - c), d3 * (1 + c)), dim=1)
        d3 = self.Up_conv3(d3)

        pred2 = self.Pred2(d3)
        c = F.interpolate(pred2.softmax(dim=1), scale_factor=2, mode='bilinear', align_corners=True)
        c = c.topk(k=2, dim=1)[0]  # ce
        c = (c[:, 0:1, :, :] - 0.5).clamp(min=0)
        # c = (c[:, 0, :, :] - c[:, 1, :, :]).unsqueeze(dim=1)
        # c = ((c - 0.5) * sig).sigmoid()
        # c = 1 - Categorical(probs=pred5.softmax(dim=1).permute(0,2,3,1)[:, :, :, 1:5]).entropy().unsqueeze(dim=1) / 1.387  # B, 1, H, W)
        d2 = self.Up2(d3)
        d2 = torch.cat((e1 * (2 - c), d2 * (1 + c)), dim=1)
        d2 = self.Up_conv2(d2)

        pred1 = self.Pred1(d2)

        # d1 = self.active(out)

        return pred1, pred2, pred3, pred4, pred5
