from utils import do_args, run_initialize
from train import Train
import os

def main():
    args = do_args()
    args.cityscapes = False
    args.isaid = True
    # args.net_model="unet"
    # args.name_prefix="unet_"
    args.net_model="DeepLab50Pretrained"
    args.name_prefix="deeplab-50-pretrained_iSAID_"
    args.name_suffix=""
    args.batch_size=4
    args.epochs=100
    args.training_steps_per_epoch=50
    args.validation_steps_per_epoch=10
    args.learning_rate=1e-3
    args.workers=2

    if args.cityscapes:
        args.hr_nclasses = 20
        args.input_nchannels = 3
    elif args.isaid:
        args.hr_nclasses = 16
        args.input_nchannels = 3


    run_initialize(args, __name__)
    train = Train(args)
    train.run()



if __name__ == '__main__':
    main()
