# Configuration of RUN_TRAINING.PY
VERBOSE = 2

# Directories
CITY = False
CITYSCAPES = False
ISAID = False
# ISAID_DIR = "/scratch/forest/datasets/iSAID_patches"
ISAID_DIR = "/scratch/forest/datasets/iSAID_patches_new"
HDF5 = False
DATA_DIR = "/scratch/forest/datasets/chesapeake_data/"
# DATA_DIR = "/scratch/forest/datasets/chesapeake_data_hdf5/"
OUTPUT_DIR = "results/"
LOG_DIR = "logs/"

# Model settings
NET_MODEL = "unet"  
ATT_HIDDEN = 32
ATT_MH = 1  # 0: all out channels share one attention. n: every n out channel have an individual attention
ATT_KS = 3
ATT_SM = 10  # Attention multiplier before softmax
ATT_TWO_W = False
FREEZE_UNTIL = 1
MULTIOUT_LOSS_TYPE = "same"
OUTPUT_STRIDE = 16
STEM_OS = 4  # For Dynamic Routing

# Training settings
EPOCHS = 100
TRAINING_STEPS_PER_EPOCH = 500
VALIDATION_STEPS_PER_EPOCH = 200
BATCH_SIZE = 32  # use 128 for full dataset (this is for NY only)
SHUFFLE = True  # enable dataset shuffle in training
LOSS = "crossentropy"  # [crossentropy, superres]
LEARNING_RATE = 0.01
STEP_SIZE = 1000000  # learning rate scheduler patience
MODEL_SAVE_CHECKPOINT = 10  # save model at each checkpoint
OPTIMIZER = "sgd"
WORKERS = 0

# Resume training
RESUME = False
RESUME_NAME = ""
RESUME_MODEL = ""  # if resume_model is not none str and resume is false, script will load the model but starts a new training

# Augmentation
DO_COLOR = False
COLOR_AUGMENTATION_INTENSITY = 0.05
DO_LABEL_OVERLOADING = False

# Experiment name
NAME_PREFIX = "Experiment_"
NAME_SUFFIX = ""

# States
TRAINING_STATES = ["md_1m_2013"]
VALIDATION_STATES = ["md_1m_2013"]
# TRAINING_STATES = ["md_1m_2013", "va_1m_2014", "wv_1m_2014"]
# VALIDATION_STATES = ["md_1m_2013", "va_1m_2014", "wv_1m_2014"]

# Weights of crossentropy and superres loss if using superres
CROSSENTROPY_LOSS_WEIGHT = 50
SUPERRES_LOSS_WEIGHT = 1

# Numpy random seed. Used to ensure we get the same validation batches
SEED = 7

# Only used if loss == superres
SUPERRES_STATES = []

# Other settings
# NOTE: If you want to remove var, assign to None
# Number of target classes
HR_NCLASSES = 5
LR_NCLASSES = 22

# Positional index of labels in patches
HR_LABEL_INDEX = 8
LR_LABEL_INDEX = 9

# Datatype of imagery
# should be int8 (divide by 255) or int16 (divide by 10000)
DATA_TYPE = "int8"
INPUT_SIZE = 256
INPUT_NCHANNELS = 4

# Keys for transformation of labels
HR_LABEL_KEY = "data/cheaseapeake_to_hr_labels.txt"
LR_LABEL_KEY = "data/nlcd_to_lr_labels.txt"

# COLORMAP files for labels
HR_COLOR = "data/hr_color.txt"
LR_COLOR = "data/nlcd_color.txt"

# LR files used for superres loss
LR_STATS_MU = "data/nlcd_mu.txt"
LR_STATS_SIGMA = "data/nlcd_sigma.txt"
LR_CLASS_WEIGHTS = "data/nlcd_class_weights.txt"
