% We consider the rectangular model (1.2) with uniform noise
% We compute a few useful quantities:
% \Delta_{\rm PCA} (DeltaPCA)
% \Gamma_{\rm PCA} (GammaPCA)
% R-transform (Rtrans)
% derivative of the R-transform (Rtrans1)

clear;
close all;
clc;

gamma = 1/2;

tolb = 5*10^(-6);
tolx = 10^(-8);

alphagrid = [0.6, 1];

DeltaPCA = zeros(1, length(alphagrid));
GammaPCA = zeros(1, length(alphagrid));
Rtrans = zeros(1, length(alphagrid));
Rtrans1 = zeros(1, length(alphagrid));

for i = 1 : length(alphagrid)
    
    alpha = alphagrid(i);
    
    fprintf('alpha=%f\n', alpha);

    z = gamma/alpha^2;
    
    xl = 1 + tolx;
    xr = 5000;
    
    Dxl = gamma * xl^2 * (log(xl^2/(xl^2-1)))^2 + (1-gamma) * log(xl^2/(xl^2-1));
    Dxr = gamma * xr^2 * (log(xr^2/(xr^2-1)))^2 + (1-gamma) * log(xr^2/(xr^2-1));
    
    if Dxr>z || Dxl<z
        fprintf('There is a problem at alpha=%f!\n Need to change xl and xr\n', alpha);
    else
        
        while Dxl-Dxr > tolb
            xm = (xl+xr)/2;
            Dxm = gamma * xm^2 * (log(xm^2/(xm^2-1)))^2 + (1-gamma) * log(xm^2/(xm^2-1));
            
            if Dxm > z
                xl = xm;
                Dxl = Dxm;
            else
                xr = xm;
                Dxr = Dxm;
            end
    
        end
        
        invD = xm;

        Dder = 2*gamma* invD * log(invD^2/(invD^2-1)) * ( log(invD^2/(invD^2-1)) - ...
            2/(invD^2-1)) - 2 * (1-gamma) / (invD*(invD^2-1));
        
        DeltaPCA(i) = - 2*z* (invD * log(invD^2/(invD^2-1)))/Dder;
        GammaPCA(i) = - 2*z* (gamma*(invD * log(invD^2/(invD^2-1)))+(1-gamma)/invD)/Dder;
        
        Rtrans(i) = (-gamma-1+sqrt((gamma+1)^2+4*gamma*(invD^2*z-1)))/(2*gamma);
        Rtrans1(i) = (invD^2+2*z*invD/Dder)/sqrt((gamma+1)^2+4*gamma*(invD^2*z-1));


    end
    
end
