% Compute the first nmax=20 rectangular free cumulants when \Lambda^2 is
% uniform in the interval [0, 1]. We use the recursive expression (A.12) in
% Appendix A.2

clear;
close all;
clc;

nmax = 20;

% The choice of nmax ensures that the program runs fast on a laptop. The 
% first 100 free cumulants have been pre-computed and stored in 
% freerectcum_unif_100.mat


m = zeros(1, nmax);

for i = 1 : nmax
    m(i) = 1/(i+1);
end

A = sym('A',[nmax nmax]);

syms x


for j = 1 : nmax 
    
    fprintf('%d\n', j);

    M = 0;

    for i = 1 : nmax +1 - j
        M = M + m(i)*x^i;
    end

    P = (x * (1/2*M+1) * (M+1))^j;

    c = coeffs(P, 'All');
    
    for i = 1 : nmax
        A(j, i) = c(length(c)+1-i-1);
    end
    
end

k = sym('k',[nmax 1]);

k(1) = m(1);

for i = 2 : nmax
    k(i) = 0;
end
    
for i = 2 : nmax
    k(i) = m(i);
    
    for j = 1 : i-1
        k(i) = k(i) - k(j) * A(j, i);
    end
    
    
end

kdouble = double(k);
