#!/usr/bin/env python3
# -*- coding: utf-8 -*-

from libsvm.svmutil import *
import time
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt

from parameters import para
from logisticregression_DC_batch import LogisticRegression_DC_batch
from logistic_base_change_lr import Logistic_DC_Change_lr

kvalue = 20000     # kvalue2
kvalue2 =1000       # kvalue1
train_size = 0.5
val_size = 0.25

# read data
y, X_train = svm_read_problem('./dataset/'+str(para.dataname)+'/'+str(para.dataname), True)
X = X_train.toarray()
y[y < 0] = 0
# y[y > 1] = 0

Model_name = "LogisticRegression"
Method = "TOPK_DC"

classifier1 = LogisticRegression_DC_batch(lr=para.lr, num_iter=para.num_iter1, inner_iter=para.inner_iter, batch=para.batch1, k_value = kvalue, k2_value = kvalue2, seed = para.seed, dataname = para.dataname, Model_name=Model_name)
classifier2 = Logistic_DC_Change_lr(lr_0=para.lr_0, num_iter=para.num_iter2, T0=para.T0, batch=para.batch2, k_value=kvalue, k2_value = kvalue2, seed = para.seed, dataname=para.dataname, Model_name=Model_name)

# classifier1 = LogisticRegression_DC_batch(lr=1, num_iter=20, inner_iter=3000, batch=100, k_value = kvalue, k2_value = kvalue2, seed = para.seed, dataname = para.dataname, Model_name=Model_name)
# classifier2 = Logistic_DC_Change_lr(lr_0=2, num_iter=14, T0=50, batch=100, k_value=kvalue, k2_value = kvalue2, seed = para.seed, dataname=para.dataname, Model_name=Model_name)

classifier1.fit(X, y, X, y, X ,y)
classifier2.fit(X, y, X, y, X ,y)

data_pass1 = classifier1.datapass
loss_base1 = classifier1.loss_list

data_pass2 = classifier2.datapass
loss_base2 = classifier2.loss_list

theta1 = classifier1.theta
theta2 = classifier2.theta

# save result
df1 = pd.DataFrame(data_pass1, columns=['data_pass'])
df2 = pd.DataFrame(loss_base1, columns=['loss_base'])
df3 = pd.DataFrame(theta1.T, columns=['theta1'])

d1 = df3.join(df2)
d2 = d1.join(df1)
s1 = str(para.dataname)+"_lr="+str(para.lr)+"_inner_iter="+str(para.inner_iter)+"_numStages="+str(para.num_iter1)+"_batch="+str(para.batch1)+"_seed="+str(para.seed)+".csv";
d2.to_csv(s1)

df4 = pd.DataFrame(data_pass2, columns=['data_pass'])
df5 = pd.DataFrame(loss_base2, columns=['loss_base'])
df6 = pd.DataFrame(theta2.T,columns=['theta2'])

d3 = df6.join(df5)
d4 = d3.join(df4)
s2 = str(para.dataname)+"_lr0="+str(para.lr_0)+"_T0="+str(para.T0)+"_numStages="+str(para.num_iter2)+"_batch="+str(para.batch2)+"_seed="+str(para.seed)+".csv";
d4.to_csv(s2)

