avg_loss_dc = mean(loss_dc,2);
avg_loss_mu_e10 = mean(loss_mu_e10,2);

avg_pauc_dc = mean(pauc_dc,2);
avg_pauc_mu_e10 = mean(pauc_mu_e10,2);

std_loss_dc = std(loss_dc,0,2);
std_loss_mu_e10 = std(loss_mu_e10,0,2);

std_pauc_dc = std(pauc_dc,0,2);
std_pauc_mu_e10 = std(pauc_mu_e10,0,2);

%% plot error bar
errorbar(datapass_dc,avg_loss_dc,std_loss_dc,'LineWidth',3)
hold on
%errorbar(datapass_dc,avg_loss_mu_e8,std_loss_mu_e8,'LineWidth',3)
%hold on
errorbar(datapass_dc,avg_loss_mu_e10,std_loss_mu_e10,'LineWidth',3)
hold off

title('CheXpert\_D5','FontSize',40)
xlim([0 150])
xlabel('# of epoch','fontweight','bold','FontSize',20)
ylabel('Training Loss','fontweight','bold','FontSize',20)
legend({'\mu=10^3/N_+N_-','\mu=10^{10}/N_+N_-'},'FontSize',20)
set(gca,'FontSize',20)
set(gca,'yscale','log')
grid on

% create smaller axes in top right, and plot on it
% axes('Position',[.22 .4 .3 .3])
axes('Position',[.25 .3 .6 .4])
box on
errorbar(datapass_dc,avg_loss_dc,std_loss_dc,'LineWidth',3)
hold on
%errorbar(datapass_dc,avg_loss_mu_e8,std_loss_mu_e8,'LineWidth',3)
%hold on
errorbar(datapass_dc,avg_loss_mu_e10,std_loss_mu_e10,'LineWidth',3)
hold off
xlim([20 150])
set(gca,'FontSize',20)
%set(gca,'yscale','log')


%%
errorbar(datapass_dc,avg_pauc_dc,std_pauc_dc,'LineWidth',3)
hold on
errorbar(datapass_dc,avg_pauc_mu_e10,std_pauc_mu_e10,'LineWidth',3)
hold off

title('CheXpert\_D5','FontSize',40)
xlim([0 150])
%ylim([0.2 0.75])
xlabel('# of epoch','fontweight','bold','FontSize',20)
ylabel('pAUC on Training set','fontweight','bold','FontSize',20)
legend({'\mu=10^3/N_+N_-','\mu=10^{10}/N_+N_-'},'FontSize',20)
set(gca,'FontSize',20)
grid on

% create smaller axes in top right, and plot on it
% axes('Position',[.22 .4 .3 .3])
axes('Position',[.25 .3 .6 .4])
box on
errorbar(datapass_dc,avg_pauc_dc,std_pauc_dc,'LineWidth',3)
hold on
errorbar(datapass_dc,avg_pauc_mu_e10,std_pauc_mu_e10,'LineWidth',3)
hold off
xlim([10 150])
set(gca,'FontSize',20)