function value = objective(w, X, y, k1, k2)
% This function returns the loss
% w is parameter.
% X is data, y is label

    s = X * w;
    ind_pos = y > 0;
    ind_neg = y < 0;
    n_pos = sum(y > 0);
    n_neg = sum(y < 0);
    s_pos = s(ind_pos);
    sum_l = 0;
    for i = 1:n_pos
        m = s_pos(i) - s(ind_neg);
        loss = 0 - m;
        loss(loss <= 0) = 0;
        loss(loss > 0) = 1;
        loss_sort = sort(loss,'descend');
        sum_l = sum_l + sum(loss_sort(k1+1:k2),'all');
    end
    value = sum_l / ((k2-k1) * n_pos);
end
