% Import and process data
train_label = readNPY('CheXpert_train_labels_all.npy');
train_data = readNPY('CheXpert_train_hidden_features_all.npy');
y = train_label;
y(y <= 0) = -1;
[n,d] = size(train_data);
num_dis = 5;
seed_list = [2,12,123,1234,12345];
alpha = 0.05;
beta = 0.5;
n_list = length(seed_list);

% add intercept
intercept = ones(n,1);
X = [intercept,train_data];

val_label = readNPY('CheXpert_valid_labels_all.npy');
val_data = readNPY('CheXpert_valid_hidden_features_all.npy');

y_val = val_label;
y_val(y_val <= 0) = -1;
[n_val,~] = size(val_data);

% add intercept
intercept = ones(n_val,1);
X_val = [intercept,val_data];

y_copy_val = y_val;
y_copy_val(y_copy_val <= 0) = 0;
n_neg_val = n_val - sum(y_copy_val(:,num_dis));
label_val = logical(y_copy_val);

k1_val = floor(n_neg_val * alpha);
k2_val = ceil(n_neg_val * beta);

% split training and validation set
train_size = 0.9;
val_size = 0.1;
n_train = round(n * train_size);
n_val = n - n_train;

p_auc_val = zeros(n_list,1);

for i = 1:n_list
    seed = seed_list(i);
    rng(seed)
    index = randperm(n);
    index_train = index(1:n_train);
    index_val = index(n_train+1:n);
    X_train = X(index_train,:);
    y_train = y(index_train,:);

    C = 0.0001;
    eps = 0.0001;
    verbosity = 1;
    % call function svmpauc_tight
    w = svmpauc_tight(X_train, y_train(:,num_dis), alpha, beta, C, eps, verbosity);

    s = X_val * w;
    p_auc_val(i) = partial_AUC(label_val(:,num_dis),s,1,k1_val,k2_val,alpha,beta)/(beta-alpha);
end    

%% plot auc with pauc for testing set
s = X_val * w_agd;
s2 = X_val * w;
s3 = X_val * w_dca;
% label = logical(y_copy);
[pauc1,fpr1,tpr1,pfpr1,ptpr1] = partial_AUC(label_val(:,num_dis),s,1,k1_val,k2_val,alpha,beta);
[pauc2,fpr2,tpr2,pfpr2,ptpr2] = partial_AUC(label_val(:,num_dis),s2,1,k1_val,k2_val,alpha,beta);
[pauc3,fpr3,tpr3,pfpr3,ptpr3] = partial_AUC(label_val(:,num_dis),s3,1,k1_val,k2_val,alpha,beta);

plot(fpr1,tpr1,'LineWidth',3);
hold on
plot(fpr2,tpr2,'LineWidth',3);
hold on
plot(fpr3,tpr3,'LineWidth',3);
hold on
plot([alpha alpha],[0 1],'--','LineWidth',3);
hold on
plot([beta beta],[0 1],'--','LineWidth',3);
hold off

xticks([0.05 0.2 0.4 0.5 0.6 0.8 1])
xticklabels({'0.05','0.2','0.4','0.5','0.6','0.8','1'})
title('AUC of CheXpert\_D5','FontSize',25)
xlabel('FPR','FontSize',20);
ylabel('TPR','FontSize',20);
set(gca,'FontSize',20)
legend({'AGD-SBCD','SVM_{pAUC}-tight','DCA'},'FontSize',20);
