avg_loss_dc = mean(loss_dc,2);
avg_loss_fix = mean(loss_fix_lr,2);
avg_loss_change = mean(loss_change_lr,2);
std_loss_dc = std(loss_dc,0,2);
std_loss_fix = std(loss_fix_lr,0,2);
std_loss_change = std(loss_change_lr,0,2);

%% plot error bar
errorbar(datapass_dc,avg_loss_dc,std_loss_dc,'LineWidth',3)
hold on
errorbar(datapass_fix,avg_loss_fix,std_loss_fix,'LineWidth',3)
hold on
errorbar(datapass_change,avg_loss_change,std_loss_change,'LineWidth',3)
hold off

title('a9a','FontSize',50)
xlim([0 100])
xlabel('# of epoch','fontweight','bold','FontSize',20)
ylabel('Training Loss','fontweight','bold','FontSize',20)
legend({'AGD-SGD','DCA.Constant.lr','DCA.Changing.lr'},'FontSize',20)
set(gca,'FontSize',20)
set(gca,'yscale','log')
grid on

% create smaller axes in top right, and plot on it
axes('Position',[.26 .3 .6 .4])
box on
errorbar(datapass_dc,avg_loss_dc,std_loss_dc,'LineWidth',3)
hold on
errorbar(datapass_fix,avg_loss_fix,std_loss_fix,'LineWidth',3)
hold on
errorbar(datapass_change,avg_loss_change,std_loss_change,'LineWidth',3)
hold off
xlim([20 100])
set(gca,'FontSize',20)
