# ADCM
To run ADCM, just run the following command:
```
CUDA_VISIBLE_DEVICES=0,1 python -m torch.distributed.launch --nproc_per_node=2 --master_port=12623 --use_env ct_train.py --outdir=ct-runs --data=datasets/cifar10-32x32.zip --cond=0 --arch=ddpmpp --metrics=fid50k_full --transfer=datasets/edm-cifar10-32x32-uncond-vp.pkl --duration=12.8 --tick=12.8 --double=250 --batch=128 --lr=0.0001 --optim=RAdam --dropout=0.3 --augment=0.0 --mode=tuning --loss_type=ADCM
```
Datasets and pretrained-DMs can be found at[^1]. You can also set up the Python environment following[^1]. 

Add 
```
--lambda=xxx
```
to the command if you want to change the Lagrange multiplier.   



# Reproduction
We have reproduced the codes of ECM[^2], sCM[^3], iCT[^4], CT[^5], and CD[^5]. The code for ECM is from [^6]. Our reproduction does not include adaptive weighting and tangent warmup in sCM, as we find they may lead to performance degradation. 

If you would like to use our reproduction code, you can simply change replace the loss_type to ECM/SCM/ICT/CT/CD. For example, if you want to run sCM, run the following command:

```
CUDA_VISIBLE_DEVICES=0,1 python -m torch.distributed.launch --nproc_per_node=2 --master_port=12623 --use_env ct_train.py --outdir=ct-runs --data=datasets/cifar10-32x32.zip --cond=0 --arch=ddpmpp --metrics=fid50k_full --transfer=datasets/edm-cifar10-32x32-uncond-vp.pkl --duration=12.8 --tick=12.8 --double=250 --batch=128 --lr=0.0001 --optim=RAdam --dropout=0.3 --augment=0.0 --mode=tuning --loss_type=SCM
```

[^1]:https://github.com/NVlabs/edm  
[^2]:Geng Z, Pokle A, Luo W, et al. Consistency models made easy[J]. arXiv preprint arXiv:2406.14548, 2024.  
[^3]:Lu C, Song Y. Simplifying, stabilizing and scaling continuous-time consistency models[J]. arXiv preprint arXiv:2410.11081, 2024.  
[^4]:Song Y, Dhariwal P. Improved Techniques for Training Consistency Models[C]//The Twelfth International Conference on Learning Representations.  
[^5]:Song Y, Dhariwal P, Chen M, et al. Consistency Models[C]//International Conference on Machine Learning. PMLR, 2023: 32211-32252.  
[^6]:https://github.com/locuslab/ect  