# Meta ODEs for Bayesian Optimization


## Installation
- Install Jax with GPU support
- Install this code repository in dev mode, e.g.,  `pip install -e.`

## Usage
The interface (either opt, train meta model) is through `main.py` with args, e.g., to train a meta-learned model or to leverage a meta-learned model for optimization

All the scripts to run experiments are expected to be stored in `\exps\scripts\`.

### Meta-Learning 
e.g., 
```
./model_comparison_train.sh exps/cfgs/lotka_voterra/sanodep.py exps/experiments/lotka_voterra/model_comparison/sanodep 0.5 301 0 5
```
refer `exps/scripts/model_comparison/model_comparison_train.sh`
### Meta Learning based Opt 
```
./optimization_comparison.sh exps/cfgs/lotka_voterra/sanodep.py exps/experiments/lotka_voterra/model_comparison/sanodep 0.5 0 20 meta_learn
```
refer `exps/scripts/optimization/optimization_comparison.sh`

## Notes:
1. If you prefer to optimize a subset of the initial condition of the original problem, please specify `config.experimental_design.initial_cond_mapper` to let the algorithm reconstruct the initial condition from the decision variables
2. For now, the multi-objective optimization is optimized based on the raw time space, if 
you have a model build within t0=0 and t1 = 1 with a `config.data.args.time_scaling_coefficient=10`, then the optimization is performed by treating the time objective function varying from [0, 10]. 
3. The current acquisition optimizer uses Scipy `trust-constr` method which is known to be unstable as can have evaluation outside the design space (https://github.com/scipy/scipy/pull/21257), which is fixed in an upcoming unrelease version, it is hence suggested to always install
the latest scipy release version in future when this issue has been fixed. 
