import numpy as np


# Get the graph
graph = np.zeros((214, 214, 364))
with open('edges.txt') as f:
    for line in f:
        tokens = line.strip().split(' ')
        graph[int(tokens[1]) - 1, int(tokens[2]) - 1, int(tokens[0]) - 1] = float(tokens[3])

layer1 = graph[:, :, :182].sum(axis=2)
layer2 = graph[:, :, 182:].sum(axis=2)
graph = np.concatenate([np.expand_dims(layer1, axis=2), np.expand_dims(layer2, axis=2)], axis=2)

# Make graphs symmetric
for layer in range(graph.shape[2]):
    graph[:, :, layer] = (graph[:, :, layer] + graph[:, :, layer].T) / 2

# Find k-nearest neighbors
knn_graph = np.zeros(graph.shape)
for layer in range(graph.shape[2]):
    indices = np.argsort(graph[:, :, layer], axis=1)[:, -5:-1]
    for i in range(graph.shape[0]):
        knn_graph[i, indices[i, :], layer] = 1
    knn_graph[:, :, layer] = ((knn_graph[:, :, layer] + knn_graph[:, :, layer].T) > 0).astype(float)


# Save the graphs
np.save('fair_mat.npy', knn_graph[:, :, 0])
np.save('adj_mat.npy', knn_graph[:, :, 1])
