import psutil
import time
import os
from subprocess import Popen
from datetime import datetime


# Control variables
infile = 'trade_exp.py'
outfile = 'trade_exp_temp'

curr_idx = 0
changes = dict()
clusters = list(range(2, 10))
groups = [5, 20, 40, 60, 80, 100, 120, 140, 160, 180, 200]
ranks = groups
for num_cluster in clusters:
    changes[curr_idx] = [('use_config = 0', 'use_config = 0'),
                         ('\'num_clusters\': 2', '\'num_clusters\': ' + str(num_cluster))]
    curr_idx += 1

    for val in groups:
        changes[curr_idx] = [('use_config = 0', 'use_config = 2'),
                             ('\'num_clusters\': 2', '\'num_clusters\': ' + str(num_cluster)),
                             ('\'num_groups\': 2', '\'num_groups\': ' + str(val))]
        curr_idx += 1

    for val in ranks:
        changes[curr_idx] = [('use_config = 0', 'use_config = 3'),
                             ('\'num_clusters\': 2', '\'num_clusters\': ' + str(num_cluster)),
                             ('\'rank\': 2', '\'rank\': ' + str(val))]
        curr_idx += 1


with open(infile) as f:
    content = f.read()

idx = 0
for key in changes:

    count = 0
    while count < 5:
        count = count + 1 if (psutil.cpu_percent(0.1) < 75 and psutil.virtual_memory().percent < 80) else 0
        time.sleep(0.2)

    new_content = content[:]
    for old, new in changes[key]:
        new_content = new_content.replace(old, new)

    curr_time = datetime.now()
    exp_name = 'Trade-' + str(curr_time.month) + '-' + str(curr_time.day) + '-' + str(curr_time.hour) + '-' + \
               str(curr_time.minute) + '-' + str(curr_time.second)
    new_content = new_content.replace('name = \'default\'', 'name = \'' + exp_name + '\'')

    curr_file = outfile + '_' + str(key) + '.py'
    with open(curr_file, 'w') as f:
        f.write(new_content)

    process = Popen(['python', curr_file])
    idx += 1
    print('Started:', idx, 'of', len(changes))

    time.sleep(1)
    os.remove(curr_file)

time.sleep(5)
