# Installation

Our code is tested with Python 3.8.20 and PyTorch 1.10.1

```bash
# install PyTorch 1.10.1
pip install torch==1.10.1+cu111 torchvision==0.11.2+cu111 -f https://download.pytorch.org/whl/cu111/torch_stable.html

# install mmcv
pip install mmcv-full==1.6.0 -f https://download.openmmlab.com/mmcv/dist/cu111/torch1.10.0/index.html

# install other requirements
pip install -r requirements.txt
```

# Data Preparation

## 1. Download nuScenes

Download the [nuScenes Dataset](https://www.nuscenes.org/download) to `./data/nuscenes`.

## 2. Create info files for CMT

```bash
python tools/create_data.py nuscenes --root-path ./data/nuscenes --out-dir ./data/nuscenes --extra-tag nuscenes
```

## 3. Download StreamPETR info files

Download the official StreamPETR nuScenes [val info file](https://github.com/exiawsh/storage/releases/download/v1.0/nuscenes2d_temporal_infos_val.pkl) to `./data/nuscenes/nuscenes2d_temporal_infos_val.pkl`. This link is copied from the official [StreamPETR repository](https://github.com/exiawsh/StreamPETR/blob/main/docs/data_preparation.md).

## 4. Folder Structure

```
AdaSensor
├── projects/
├── tools/
├── configs/
├── checkpoints/
│   ├── AdaSensor_ckpt.pth
├── data/
│   ├── nuscenes/
│   │   ├── maps/
│   │   ├── samples/
│   │   ├── sweeps/
│   │   ├── v1.0-test/
|   |   ├── v1.0-trainval/
|   |   ├── nuscenes_infos_val.pkl
|   |   ├── nuscenes2d_temporal_infos_val.pkl
```

# Evaluation
The checkpoint of AdaSensor can be downloaded from [this anonymous link](https://mega.nz/file/OmBymArI#2tP0N6UKbrf76f0Qwhb8qCOzlDA11IpYHmNl3YMyVJw). You should save the checkpoint to `checkpoints/AdaSensor_ckpt.pth`.

You can use the following command to perform evaluation on the nuScenes dataset. The sensor boot time in the command is the same as in the paper. 

> Note: if you are running the command on a **non-Jetson** platform (e.g., RTX 3090), please REMOVE the `--tegrastats` option, as this option is used to record the power consumption of the computing platform using `tegrastats`.

```bash
python tools/test_adasensor.py \
  projects/configs/cmt_streampetr_vitmini.py \
  checkpoints/AdaSensor_ckpt.pth \
  --tegrastats \
  --sensor-default-status activated \
  --camera-boot-time 3.20 --lidar-boot-time 4.04 --camera-power 1.2 --lidar-power 15.7 \
  --camera-min-duration 15.0 \
  --lidar-min-duration 15.0 \
  --save-power-data eval_power_data.json \
  --save-metas eval_metas.json \
  --save-results eval_results.json
```

# Code Guidance

- differentiable top-p sampling: `projects/mmdet3d_plugin/models/detectors/cmt_modal_router.py`, Line 491-537
- load balancing loss: `projects/mmdet3d_plugin/models/detectors/cmt_modal_router.py`, Line 202
- dynamic loss: `projects/mmdet3d_plugin/models/detectors/cmt_modal_router.py`, Line 199
- inference pipeline: `projects/mmdet3d_plugin/models/detectors/scene_detector.py`, Line 818-1021
- attention mask for power-efficient robust training: `projects/mmdet3d_plugin/models/dense_heads/cmt_head.py`. Line 477-505

# Trouble Shooting

## ImportError: cannot import name 'container_abcs' from 'torch._six'
Edit your `timm/models/layers/helpers.py` file in the `timm` package as follows:
```python
from itertools import repeat
# from torch._six import container_abcs # remove this line
from collections import abc as container_abcs # add this line
```