# Conditional Adversarial Support Alignment

## Code 

In this codebase we provide the following:

* The implementation of the Conditional Adversarial Support Alignment (CASA) method as proposed in the research paper.
* A framework designed for training and evaluating domain adaptation methods when there is a shift in label distribution.
* Baseline domain adaptation methods:
  * Methods for distribution alignment: DANN, CDAN, VADA.
  * Methods for relaxed distribution alignment (reweighting): sDANN, IWDAN/IWCDAN, ASA
  * Methods for prototypes alignment and entropy minimization: PCT, SENTRY

## Data downloading

USPS, MNIST, STL, and CIFAR10 downloading is handled by `torchvision`.
Data for other benchmarks can be downloaded from the following links:
1. [VisDA17](https://github.com/VisionLearningGroup/taskcv-2017-public/tree/master/classification)
3. [Office31](https://people.eecs.berkeley.edu/~jhoffman/domainadapt/)

## Training script

Main script for training is `support_alignment.scripts.train`. Training command template:
```bash
python3 -m support_alignment.scripts.train \
  --config_name=<CONFIG_NAME> \    
  --experiment_root=<EXPERIMENT_ROOT> \
  --data_root=<DATA_ROOT> \
  [--cuda] \
  [--experiment_name_override=<EXPERIMENT_NAME_OVERRIDE>] \
  [--force_overwrite] \
  [--wb_log] \
  [--wb_save_model]
```

The parameters and flags are 
* ```CONFIG_NAME``` &mdash; name of the experiment config (see config info below);
* ```EXPERIMENT_ROOT``` &mdash; path to experiment root directory which will be used to store experiment results;
* ```DATA_ROOT``` &mdash; path to data root directory where the datasets are located (torchvision datasets will be dowloaded to this location);
* ```--cuda``` (optional) &mdash; if specified the training will be run on an available cuda device;
* ```EXPERIMENT_NAME_OVERRIDE``` (optional) &mdash; if specified overrides experiment name, by default experiment name is the confing name;
* ```--force_overwrite``` (optilnal) &mdash; if specified, the experiment directory will be overwritten (if exists);
* ```--wb_log``` (optional) &mdash; if specified experiment statistics and results will be logged to [Weights&Biases](https://docs.wandb.ai/) (wandb);
* ``--wb_save_model`` (optional) &mdash; if specified model checkpoints will be saved to wandb.

## Experiment configs

Experiment configs are stored in `support_alignment.experiment_registry.registry`. The training script
`support_alignment.scripts.train` finds a config by its name (`CONFIG_NAME`) in the registry.

## References

The code were largely adapted from the following repositories:
* https://github.com/timgaripov/asa
* https://github.com/microsoft/Domain-Adaptation-with-Conditional-Distribution-Matching-and-Generalized-Label-Shift/
