from .normal import NormalLearner
from .atari import AtariLearner
from .atari_lb import AtariLowerBoundedLearner

learner_collection = {
	'normal': NormalLearner,
	'atari': AtariLearner,
	'atari_lb': AtariLowerBoundedLearner,
}

def create_learner(args):
	return learner_collection[args.learn](args)
