# Fast and Stable Continual Test-Time Adaptation via Masked Modeling and Momentum-Guided Updates

This repository contains the official implementation of **MiDEA** for Continual Test-Time Adaptation (CTTA).

## Overview

MiDEA achieves state-of-the-art performance on continual test-time adaptation benchmarks while running 3-6x faster than existing methods. Our approach combines masked image modeling with a novel dual-rate exponential moving average (EMA) mechanism to balance plasticity and stability during adaptation.

## Prerequisites and Setup

### Environment Configuration

**Hardware Requirements:**
- GPU with at least 8GB VRAM (experiments conducted on NVIDIA GeForce RTX 3080 10GB)
- ~5GB GPU memory consumption for batch size 8 configurations

**Main Dependencies:**
- Python 3.8
- PyTorch 1.13.1
- CUDA 11.7

Create a conda environment using the provided `environment.yml` file:

```bash
conda env create -f adapt/environment.yml
conda activate midea-env
```


### Data and Model Preparation

1. **Download ImageNet-C corruption dataset:**
   ```
   https://zenodo.org/records/2235448
   ```

2. **Download pre-trained ViT-Base model weights:**
   ```
   https://storage.googleapis.com/vit_models/augreg/B_16-i21k-300ep-lr_0.001-aug_medium1-wd_0.1-do_0.0-sd_0.0--imagenet2012-steps_20k-lr_0.01-res_224.npz
   ```

3. **Extract and organize:**
   - Place ImageNet-C data in your preferred directory
   - Place model weights in `adapt/ckpt/` directory

## Execution Instructions

### ImageNet-C Evaluation

1. **Configure paths** in `adapt/bash/mimic.sh`:
   ```bash
   --data_dir /path/to/your/imagenet-c/data
   --checkpoint ./ckpt/B_16-i21k-300ep-lr_0.001-aug_medium1-wd_0.1-do_0.0-sd_0.0--imagenet2012-steps_20k-lr_0.01-res_224.npz
   ```

2. **Run evaluation:**
   ```bash
   cd adapt/
   bash bash/mimic.sh
   ```

## Expected Results

The script will generate comprehensive results matching those reported in our paper:

- **ImageNet-C**: ~38.1% error rate (62% accuracy)

## Reproducibility

All hyperparameters and experimental configurations are pre-configured to ensure exact reproducibility of reported findings.

### CIFAR-10-C and CIFAR-100-C Evaluations

To reproduce CIFAR results, modify both the configuration file and bash script:

#### Configuration Updates
Edit `cfgs/vit/mimic.yaml` to match the hyperparameters reported in the paper:
- **Learning rate**: Set according to Experiments section specifications
- **EMA rates**: Update dual-rate parameters as specified for each dataset
- **Batch size**: Configure as reported in experimental setup

#### Script Modifications
Update the bash script parameters:
```bash
# Change dataset specification
--data_set cifar10    # or cifar100 for CIFAR-100-C

# Update checkpoint path to original source weights (download from VIDA GitHub)
--checkpoint ./ckpt/weights
```

## Performance Characteristics

- **Speed**: 3× faster than existing CTTA methods (6x when competitors use stochastic restore)
- **Memory**: ~5GB GPU memory for batch size 8
- **Scalability**: Maintains performance even at batch size 1 for real-time applications

## File Structure

```
├── adapt/
│   ├── environment.yml          # Conda environment specification
│   ├── bash/
│   │   ├── mimic.sh            # ImageNet-C evaluation script
│   │   └── ...                 # Additional evaluation scripts
│   ├── ckpt/                   # Model checkpoints directory
│   
├── README.md                   # This file
└── supplementary.pdf           # Detailed technical appendix
```

## Citation

If you find this work useful, please consider citing our paper:

```bibtex
@article{midea2026,
  title={Fast and Stable Continual Test-Time Adaptation via Masked Modeling and Momentum-Guided Updates},
  author={Anonymous Submission},
  year={2026}
}
```

## Contact


---

**Note**: This is an anonymous submission. Full author information and institutional affiliations will be provided upon acceptance.