# Note: Add a `--gen-data` flag the first time using any particular environment

################################
#     Pointmass Navigation     #
################################

# BC
python scripts/run_bc.py --env mpb --n-demos --init-iters 10000

# SAC
python scripts/run_sac.py --env mpb --n-demos --tau 0.05 --init-iters 2000

# SAC DRTG
python scripts/run_sac.py --env mpb --n-demos --tau 0.05 --init-iters 2000 --do-drtg-bonus

# TD3
python scripts/run_td3.py --env mpb --n-demos --init-iters 2000 --tau 0.05

# TD3 DRTG
python scripts/run_td3.py --env mpb --n-demos --init-iters 2000 --tau 0.05 --do-drtg-bonus

# GQE
python scripts/run_sac.py --env mpb --n-demos 20 --tau 0.05 --total-timesteps 150000 --gqe --gqe-lambda 0.9

# GQE DRTG
python scripts/run_sac.py --env mpb --n-demos 20 --tau 0.05 --total-timesteps 150000 --gqe --gqe-lambda 0.9 --do-drtg-bonus

# OEFD
python scripts/run_td3.py --env mpb --n-demos --init-iters 2000 --tau 0.05 --do-bc-loss --do-q-filter

# OEFD DRTG
python scripts/run_td3.py --env mpb --n-demos --init-iters 2000 --tau 0.05 --do-bc-loss --do-q-filter --do-drtg-bonus

# AWAC
python scripts/run_awac.py --env mpb --n-demos --update-n-steps 50 --eval-freq 500 --num-eval-episodes 10 --init-iters 10000

# AWAC DRTG
python scripts/run_awac.py --env mpb --n-demos --update-n-steps 50 --eval-freq 500 --num-eval-episodes 10 --init-iters 10000 --do-drtg-bonus



########################
#   Block Extraction   #
########################

# BC
python scripts/run_bc.py --env extraction-random --init-iters 10000

# SAC
python scripts/run_sac.py --env extraction-random --eval-freq 1000 --num-eval-episodes 5 --alpha 0.1

# SAC DRTG
python scripts/run_sac.py --env extraction-random --eval-freq 1000 --num-eval-episodes 5 --alpha 0.1 --do-drtg-bonus

# TD3
python scripts/run_td3.py --env extraction-random --eval-freq 1000 --num-eval-episodes 5

# TD3 DRTG
python scripts/run_td3.py --env extraction-random --eval-freq 1000 --num-eval-episodes 5 --do-drtg-bonus

# GQE
python scripts/run_sac.py --env extraction-random --alpha 0.1 --eval-freq 1000 --num-eval-episodes 5 --n-demos 50 --total-timesteps 200000 --gqe --gqe-n 8 --gqe-lambda 0.95

# GQE DRTG
python scripts/run_sac.py --env extraction-random --alpha 0.1 --eval-freq 1000 --num-eval-episodes 5 --n-demos 50 --total-timesteps 200000 --do-drtg-bonus --gqe --gqe-n 8 --gqe-lambda 0.95

# OEFD
python scripts/run_td3.py --env extraction-random --eval-freq 1000 --num-eval-episodes 5 --do-bc-loss --do-q-filter

# OEFD DRTG
python scripts/run_td3.py --env extraction-random --eval-freq 1000 --num-eval-episodes 5 --do-bc-loss --do-q-filter --do-drtg-bonus

# AWAC
python scripts/run_awac.py --env extraction-random --update-n-steps 50 --eval-freq 1000 --num-eval-episodes 5 --init-iters 10000

# AWAC DRTG
python scripts/run_awac.py --env extraction-random --update-n-steps 50 --eval-freq 1000 --num-eval-episodes 5 --init-iters 10000 --do-drtg-bonus


##########################
#   Sequential Pushing   #
##########################

# BC
python scripts/run_bc.py --env push-2 --n-demos 500 --init-iters 10000

# SAC
python scripts/run_sac.py --env push-2 --n-demos 500 --eval-freq 1000 --num-eval-episodes 5 --alpha 0.1

# SAC DRTG
python scripts/run_sac.py --env push-2 --n-demos 500 --eval-freq 1000 --num-eval-episodes 5 --alpha 0.1 --do-drtg-bonus

# TD3
python scripts/run_td3.py --env push-2 --n-demos 500 --eval-freq 1000 --num-eval-episodes 5

# TD3 DRTG
python scripts/run_td3.py --env push-2 --n-demos 500 --eval-freq 1000 --num-eval-episodes 5 --do-drtg-bonus

# GQE
python scripts/run_sac.py --env push-2 --n-demos 500 --alpha 0.1 --eval-freq 1000 --num-eval-episodes 5 --total-timesteps 250000 --gqe --gqe-n 16 --gqe-lambda 0.95

# GQE DRTG
python scripts/run_sac.py --env push-2 --n-demos 500 --alpha 0.1 --eval-freq 1000 --num-eval-episodes 5 --total-timesteps 250000 --do-drtg-bonus --gqe --gqe-n 16 --gqe-lambda 0.95

# OEFD
python scripts/run_td3.py --env push-2 --n-demos 500 --eval-freq 1000 --num-eval-episodes 5 --do-bc-loss --do-q-filter

# OEFD DRTG
python scripts/run_td3.py --env push-2 --n-demos 500 --eval-freq 1000 --num-eval-episodes 5 --do-bc-loss --do-q-filter --do-drtg-bonus

# AWAC
python scripts/run_awac.py --env push-2 --n-demos 500 --update-n-steps 50 --eval-freq 1000 --num-eval-episodes 5 --init-iters 10000

# AWAC DRTG
python scripts/run_awac.py --env push-2 --n-demos 500 --update-n-steps 50 --eval-freq 1000 --num-eval-episodes 5 --init-iters 10000 --do-drtg-bonus




########################
#     Door Opening     #
########################

# BC
python scripts/run_bc.py --env Door --n-demos 100 --init-iters 10000

# SAC
python scripts/run_sac.py --env Door --n-demos 100 --alpha 0.05 --eval-freq 1000 --num-eval-episodes 5

# DRTG SAC
python scripts/run_sac.py --env Door --n-demos 100 --alpha 0.05 --eval-freq 1000 --num-eval-episodes 5 --do-drtg-bonus

# TD3
python scripts/run_td3.py --env Door --n-demos 100 --eval-freq 1000 --num-eval-episodes 5

# DRTG TD3
python scripts/run_td3.py --env Door --n-demos 100 --eval-freq 1000 --num-eval-episodes 5 --do-drtg-bonus

# GQE
python scripts/run_sac.py --env Lift --n-demos 100 --alpha 0.05 --eval-freq 1000 --num-eval-episodes 5 --total-timesteps 200000 --gqe --gqe-n 16

# GQE DRTG
python scripts/run_sac.py --env Lift --n-demos 100 --alpha 0.05 --eval-freq 1000 --num-eval-episodes 5 --total-timesteps 200000 --do-drtg-bonus --gqe --gqe-n 16

# OEFD
python scripts/run_td3.py --env Door --n-demos 100 --eval-freq 1000 --num-eval-episodes 5 --do-bc-loss --do-q-filter

# DRTG OEFD
python scripts/run_td3.py --env Door --n-demos 100 --eval-freq 1000 --num-eval-episodes 5 --do-bc-loss --do-q-filter --do-drtg-bonus

# AWAC
python scripts/run_awac.py --env Door --n-demos 100 --eval-freq 1000 --num-eval-episodes 5 --update-n-steps 50 --init-iters 10000 --do-bc-loss --do-q-filter

# DRTG AWAC
python scripts/run_awac.py --env Door --n-demos 100 --eval-freq 1000 --num-eval-episodes 5 --update-n-steps 50 --init-iters 10000 --do-bc-loss --do-q-filter --do-drtg-bonus


########################
#     Block Lifting    #
########################

# BC
python scripts/run_bc.py --env Lift --n-demos 100 --init-iters 10000

# SAC
python scripts/run_sac.py --env Lift --n-demos 100 --alpha 0.05 --eval-freq 1000 --num-eval-episodes 5

# DRTG SAC
python scripts/run_sac.py --env Lift --n-demos 100 --alpha 0.05 --eval-freq 1000 --num-eval-episodes 5 --do-drtg-bonus

# TD3
python scripts/run_td3.py --env Lift --n-demos 100 --eval-freq 1000 --num-eval-episodes 5

# DRTG TD3
python scripts/run_td3.py --env Lift --n-demos 100 --eval-freq 1000 --num-eval-episodes 5 --do-drtg-bonus

# GQE
python scripts/run_sac.py --env Door --n-demos 100 --alpha 0.05 --eval-freq 1000 --num-eval-episodes 5 --total-timesteps 200000 --gqe --gqe-n 16

# GQE DRTG
python scripts/run_sac.py --env Door --n-demos 100 --alpha 0.05 --eval-freq 1000 --num-eval-episodes 5 --total-timesteps 200000 --do-drtg-bonus --gqe --gqe-n 16

# OEFD
python scripts/run_td3.py --env Lift --n-demos 100 --eval-freq 1000 --num-eval-episodes 5 --do-bc-loss --do-q-filter

# DRTG OEFD
python scripts/run_td3.py --env Lift --n-demos 100 --eval-freq 1000 --num-eval-episodes 5 --do-bc-loss --do-q-filter --do-drtg-bonus

# AWAC
python scripts/run_awac.py --env Lift --n-demos 100 --eval-freq 1000 --num-eval-episodes 5 --update-n-steps 50 --init-iters 10000 --do-bc-loss --do-q-filter

# DRTG AWAC
python scripts/run_awac.py --env Lift --n-demos 100 --eval-freq 1000 --num-eval-episodes 5 --update-n-steps 50 --init-iters 10000 --do-bc-loss --do-q-filter --do-drtg-bonus


