# Panacea

# Prepare Conda Environment

Create a Conda environment with Python 3.10:
```sh
conda create -n panacea
conda activate panacea
conda install python=3.10.11
```

For using GPU with CUDA, directly install PyG from the official channel:
```sh
conda install pytorch torchvision cudatoolkit -c pytorch
conda install pyg -c pyg
```

Install other necessary packages:
```sh
conda install seaborn scikit-learn tqdm matplotlib tensorboard networkx statsmodels
```

# Prepare Dataset

### Road Traffic Dataset
Download the METR-LA and PEMS-BAY dataset from https://github.com/mengcz13/KDD2021_CNFGNN.

### Car Image Classification Dataset
Download and extract the dataset by following the instruction here http://mmlab.ie.cuhk.edu.hk/datasets/comp_cars/instruction.txt, and then rename the directory 'image' to 'compcars' and put it under 'data' directory.


# Evaluation

## Run Experiments

We include example commands for running all experiments in `NeurIPS2023_panacea_all_exps.ipynb`. If you want to run experiments with different hyperparameters, please check the help information:
```sh
python trainer.py --help
```

## View Results

We use the `tensorboard` and `hparam` plugin to log the experimental results, including loss, accuracy, and hyperparameters. To see the results, you can use the script in `tbparser.ipynb` to export the experiment results into a `.csv` file. Or, you can launch the tensorboard with the following command and open http://localhost:6006 in the browser:
```
tensorboard --logdir runs
```
To check the hyperparameters of each run, you can switch to the `HParam` tab from the top right corner.