import os

import numpy as np
import matplotlib.pyplot as plt
import scipy.interpolate

import path_config

np.set_printoptions(linewidth=5000)

load_ranges = True
if load_ranges:
    paths = path_config.get_paths()
    hcas_root = paths['acas']
    tabledir = os.path.join(hcas_root, "GenerateTable")
    ranges_fullfilename = os.path.join(tabledir, "ranges.txt")
    RANGES = np.loadtxt(ranges_fullfilename, delimiter=",", ndmin=1)
else:

    RANGES = [
        0.0,
        25.0,
        50.0,
        75.0,
        100.0,
        150.0,
        200.0,
        300.0,
        400.0,
        500.0,
        510.0,
        750.0,
        1000.0,
        1500.0,
        2000.0,
        3000.0,
        4000.0,
        5000.0,
        7000.0,
        9000.0,
        11000.0,
        13000.0,
        15000.0,
        17000.0,
        19000.0,
        21000.0,
        25000.0,
        30000.0,
        35000.0,
        40000.0,
        48000.0,
        56000.0,
    ]


if __name__ == "__main__":
    size_mult = 4

    range_len = len(RANGES)
    x = np.arange(range_len)
    y = np.array(RANGES)

    f = scipy.interpolate.interp1d(x, y)
    xnew = np.linspace(x[0], x[-1], range_len * size_mult)
    ynew = f(xnew)

    RANGES_NEW = ynew

    # plt.plot(x, y)
    # plt.plot(xnew, ynew)

    # new_range_len = size_mult * range_len
    #
    # new_range = [None] * new_range_len
    # for idx in range(1, range_len):
    #     # idx = 1
    #     # idx = 2
    #     # print(idx)
    #     i0 = idx - 1
    #     i1 = idx
    #
    #     v0 = RANGES[i0]
    #     v1 = RANGES[i1]
    #
    #     lower = v0
    #     upper =
    #     to_add = np.linspace(v0, v1, size_mult + 1).tolist()
    #
    #     a_i0 = i0 * size_mult
    #     a_i1 = i1 * size_mult
    #     print(a_i0, a_i1)
    #     new_range[a_i0:a_i1] = to_add
