import functools
import time
import timeit


def simple_fun(n: int) -> None:
    time.sleep(.1)


@functools.lru_cache(maxsize=16)
def simple_fun_cached(n: int) -> None:
    time.sleep(.1)


if __name__ == "__main__":
    number = 50

    s = functools.partial(simple_fun, 1)
    s_cached = functools.partial(simple_fun_cached, 1)

    num = timeit.timeit(s, number=number) / number
    num_cached = timeit.timeit(s_cached, number=number) / number
