from typing import List

import numpy as np

import plotting
import tools


def _get_test_data() -> List[np.ndarray]:
    lv = [
        np.array(
            [
                [1.0, 0.02493329, -0.07749795],
                [1.0, 0.2451464, -0.6959906],
                [1.0, 0.66420244, -0.20282648],
            ]
        ),
        np.array(
            [
                [1.0, 0.02493329, -0.07749795],
                [1.0, 0.0196929, -0.07647057],
                [1.0, -0.40002392, -0.67195612],
                [1.0, 0.2451464, -0.6959906],
            ]
        ),
        np.array(
            [
                [1.0, 0.45590974, 0.54242486],
                [1.0, 0.0229315, -0.07187571],
                [1.0, 0.66420244, -0.20282648],
                [1.0, 0.02493329, -0.07749795],
            ]
        ),
        np.array(
            [
                [1.0, -0.74676388, 0.07379306],
                [1.0, 0.0196929, -0.07647057],
                [1.0, -0.40002392, -0.67195612],
            ]
        ),
        np.array(
            [
                [1.0, -0.17081764, 0.66424605],
                [1.0, -0.22282363, 0.6183545],
                [1.0, 0.0229315, -0.07187571],
                [1.0, 0.45590974, 0.54242486],
            ]
        ),
        np.array(
            [
                [1.0, 0.0229315, -0.07187571],
                [1.0, 0.0196929, -0.07647057],
                [1.0, 0.02493329, -0.07749795],
            ]
        ),
        np.array(
            [
                [1.0, 0.0229315, -0.07187571],
                [1.0, -0.22282363, 0.6183545],
                [1.0, -0.49058958, 0.38207029],
                [1.0, -0.74676388, 0.07379306],
                [1.0, 0.0196929, -0.07647057],
            ]
        ),
        np.array(
            [
                [1.0, -0.22282363, 0.6183545],
                [1.0, -0.24466013, 0.67968472],
                [1.0, -0.17081764, 0.66424605],
            ]
        ),
        np.array(
            [
                [1.0, -0.22282363, 0.6183545],
                [1.0, -0.24466013, 0.67968472],
                [1.0, -0.49058958, 0.38207029],
            ]
        ),
    ]
    return lv


if __name__ == "__main__":
    lv = _get_test_data()
    plotting.list_of_convex_hull_plot_simple(lv)

    num_polytopes = len(lv)
    lh = [tools.v_to_h(v, None, True) for v in lv]

    is_convex_union = np.full((num_polytopes, num_polytopes), np.nan)
    distances = np.full((num_polytopes, num_polytopes), np.nan)
    for i1 in range(num_polytopes):
        h1 = lh[i1]
        for i2 in range(i1):
            h2 = lh[i2]
            if i1 == i2:
                continue
            else:
                ic = tools.is_union_of_h_reprs_convex(h1, h2)
                is_convex_union[i1, i2] = ic


