import math
from typing import Tuple

# https://github.com/openai/gym/blob/master/gym/envs/classic_control/cartpole.py


def compute_accelerations() -> Tuple[float, float]:
    temp = (force + polemass_length * theta_dot * theta_dot * sintheta) / total_mass
    thetaacc = (gravity * sintheta - costheta * temp) / (
                length * (4.0 / 3.0 - masspole * costheta * costheta / total_mass))
    xacc = temp - polemass_length * thetaacc * costheta / total_mass
    return xacc, thetaacc


if __name__ == "__main__":

    gravity = 9.8
    masscart = 1.0
    masspole = 0.1
    total_mass = (masspole + masscart)
    length = 0.5  # actually half the pole's length
    polemass_length = (masspole * length)
    force_mag = 10.0
    tau = 0.02  # seconds between state updates

    theta_threshold_radians = 12 * 2 * math.pi / 360
    x_threshold = 2.4

    force_sign = +1
    force = force_sign * force_mag
    theta_dot = 0

    theta = theta_threshold_radians
    costheta = math.cos(theta)
    sintheta = math.sin(theta)



