import numpy as np
import scipy.optimize


# examples from:
# https://docs.scipy.org/doc/scipy/reference/generated/scipy.optimize.minimize.html#scipy.optimize.minimize


def test1():
    x0 = [1.3, 0.7, 0.8, 1.9, 1.2]
    res = scipy.optimize.minimize(scipy.optimize.rosen,
                                  x0,
                                  method='Nelder-Mead', tol=1e-6)
    np.testing.assert_allclose(res.x, 1, atol=1e-6)


def test2():
    x0 = [1.3, 0.7, 0.8, 1.9, 1.2]
    options = {'gtol': 1e-6, 'disp': True}
    res = scipy.optimize.minimize(scipy.optimize.rosen,
                   x0,
                   method='BFGS',
                   jac=scipy.optimize.rosen_der,
                   options=options)
    np.testing.assert_allclose(res.x, 1, atol=1e-6)


def test3():
    fun = lambda x: (x[0] - 1) ** 2 + (x[1] - 2.5) ** 2

    cons = ({'type': 'ineq', 'fun': lambda x: +x[0] - 2 * x[1] + 2},
            {'type': 'ineq', 'fun': lambda x: -x[0] - 2 * x[1] + 6},
            {'type': 'ineq', 'fun': lambda x: -x[0] + 2 * x[1] + 2})
    bnds = ((0, None), (0, None))
    x0 = (2, 0)
    res = scipy.optimize.minimize(fun,
                                  x0,
                                  method='SLSQP',
                                  bounds=bnds,
                                  constraints=cons)
    np.testing.assert_allclose(res.x, [1.4, 1.7], atol=1e-6)


if __name__ == "__main__":
    test1()
    test2()
    test3()
