# Code to accompany 'Computing Preimages of Deep Neural Networks with Applications to Safety'

Here is code which inverts deep neural networks that can be written as the composition of relu and linear layers. 

The main requirements are Python3 (developed on 3.7.4), PyTorch, and Gurobi.
NB. Gurobi requires a license and must be installed separately. This code was developed on Gurobi 9, and requires some features not present in Gurobi 8.

Install the necessary Python packages with the `requirements.txt` (e.g. I do `pip3 install -r requirements.txt`).
Optionally run the tests (e.g. `py.test -v tests/`)

  - The ''two moons'' example can be replicated with `main.py`, setting `experiment_name = "moons"`.
    - Many other experiments can be performed from here, for example invering a simple MNIST CNN classifier. 
  - The cart pole experiment lives at `gym/cartpole_policy_gradient`, and the velocity magnitude computation can be performed with the function `compute_velocity_limits_simple` in that file.
  - The ACAS example is contained in the `acas` directory, which contains a self-contained and slimmed-down variant of the code from Julian and Kochenderfer (https://github.com/sisl/HorizontalCAS).
    - `acas/GenerateTable` contains code that builds and solves the dynamic programming problem to develop the state-value (Q) table (as a ) _this computation requires Julia and several packages_ -- see the referenced Github for more information. 
    - `acas/genTrainingData.py` consumes the hdf5-form table generated above and does some light reshaping and calculation to build the raw data that neural networks are fit upon.
    - `acas/traingHCAS.py` does the training of ACAS neural networks with the modifications to Julian and Kochenderfer's method described in the paper (cross entropy loss, psi >= 0). _This computation requires Tensorflow 1_.
    - `acas/invert_hcas_network.py` performs the inversion and builds the encounter plot used in the paper.
  - The timing results reported in the appendix (and others) can be generated using `timings.py`.

