import numpy as np

import pytest
import cvxpy

import tools


def _get_prob() -> cvxpy.Problem:
    h1 = np.array(
        [
            [0.3439656, 1.0, 0.0],
            [-0.00813415, 0.0, 1.0],
            [-0.3439656, -1.0, -0.0],
            [0.00813415, -0.0, -1.0],
        ]
    )

    h2 = np.array(
        [
            [-2.85814048, 3.49222856, -1.0],
            [1.0, 87.22720612, 34.54868512],
            [9.28723164, -12.21954789, 1.0],
            [1.0, -9.27157007, -6.98121643],
        ]
    )
    dim = 3
    p1 = cvxpy.Variable(dim)
    p2 = cvxpy.Variable(dim)

    iota0 = tools.vec(0 == np.arange(dim)).astype(float)

    constraints = [h1 @ p1 >= 0, h2 @ p2 >= 0, iota0.T @ p1 == 1, iota0.T @ p2 == 1]
    p = "inf"
    # p = 1
    objective = cvxpy.Minimize(cvxpy.pnorm(p1 - p2, p=p))

    prob = cvxpy.Problem(objective, constraints)
    return prob


@pytest.mark.xfail
def test_osqp_failure():
    prob = _get_prob()
    prob.solve(verbose=True)


def test_gurobi_success():
    prob = _get_prob()
    solver = cvxpy.GUROBI
    prob.solve(verbose=True, solver=solver)


if __name__ == "__main__":
    test_osqp_failure()
