import itertools

import numpy as np


def gini(x: np.ndarray) -> float:
    n = len(x)
    diffs = sum(abs(i - j) for i, j in itertools.combinations(x, r=2))
    return diffs / (2 * n**2 * x.mean())


if __name__ == "__main__":

    # https://www3.nd.edu/~wbrooks/GiniNotes.pdf
    x = np.array([.10, .15, .35, .40])

    gini(x)
