from typing import Tuple

import numpy as np

import plotting

lim = Tuple[float, float]


def _limits_greater_than(
    lims_less: Tuple[lim, lim], lims_more: Tuple[lim, lim]
) -> bool:
    xlim_less, ylim_less = lims_less
    xlim_more, ylim_more = lims_more

    xlim_greater = (xlim_less[0] >= xlim_more[0]) and (xlim_less[1] <= xlim_more[1])
    ylim_greater = (ylim_less[0] >= ylim_more[0]) and (ylim_less[1] <= ylim_more[1])
    return xlim_greater and ylim_greater


def test_boundary_expansion():
    v1 = np.array([[+1.0, -0.34396560, 0.00813415]])
    v2 = np.array(
        [
            [+1.0, 0.32562991, -1.72096641],
            [+1.0, 0.47020114, -1.21609062],
            [+1.0, 0.62792271, -1.61430003],
            [+1.0, 0.54858121, -2.58381731],
        ]
    )
    v_list = [v1, v2]
    xlim, ylim = plotting.get_plotlims_from_list_of_v_forms(v_list)
    factor = 0.0
    lims1 = plotting.get_plotlims_from_v_form(v1, factor)
    lims2 = plotting.get_plotlims_from_v_form(v2, factor)

    assert _limits_greater_than(lims1, (xlim, ylim))
    assert _limits_greater_than(lims2, (xlim, ylim))


if __name__ == "__main__":
    test_boundary_expansion()
