import pytest


# pytest -rx xfail_demo.py
# http://doc.pytest.org/en/latest/skipping.html


@pytest.mark.xfail
def test_hello():
    assert 0


@pytest.mark.xfail(run=False)
def test_hello2():
    assert 0


@pytest.mark.xfail("hasattr(os, 'sep')")
def test_hello3():
    assert 0


@pytest.mark.xfail(reason="bug 110")
def test_hello4():
    assert 0


@pytest.mark.xfail('pytest.__version__[0] != "17"')
def test_hello5():
    assert 0


def test_hello6():
    pytest.xfail("reason")


@pytest.mark.xfail(raises=IndexError)
def test_hello7():
    x = []
    x[1] = 1


@pytest.mark.skip(reason="no way of currently testing this")
def test_the_unknown():
    pass


def test_function():
    pytest.skip("unsupported configuration")
