import math
import numpy as np


def gmm_threshold(n, d, K, gamma, sigma=1.0, seed=None):
    """Generate samples from GMM."""
    log_n = math.log(n)
    ThetaSq = 1 + math.sqrt(1 + K * d / (n * log_n))
    ThetaSq *= 4. * log_n * sigma ** 2.
    Theta_min_sq = gamma * ThetaSq

    center = math.sqrt(Theta_min_sq / 2) * np.eye(d)[:K]
    rng = np.random.default_rng(seed=seed)
    label = rng.integers(K, size=n)
    X = sigma * rng.normal(size=(n, d)) + center[label]

    return X, label
