#!/bin/bash

# Use 42 as default if no seed is provided
SEED=${1:-42}

python -m src.main algorithm=auto_qd env=bipedal_walker seed=$SEED algorithm.measures_dim=1 logging.tags="['ablation', 'measure_dim1']" logging.group="ablation"
python -m src.main algorithm=auto_qd env=bipedal_walker seed=$SEED algorithm.measures_dim=2 logging.tags="['ablation', 'measure_dim2']" logging.group="ablation"
python -m src.main algorithm=auto_qd env=bipedal_walker seed=$SEED algorithm.measures_dim=3 logging.tags="['ablation', 'measure_dim3']" logging.group="ablation"
python -m src.main algorithm=auto_qd env=bipedal_walker seed=$SEED algorithm.measures_dim=4 logging.tags="['ablation', 'measure_dim4']" logging.group="ablation"


python -m src.main algorithm=auto_qd env=bipedal_walker seed=$SEED algorithm.embedding.dim=10 logging.tags="['ablation', 'emb_dim10']" logging.group="ablation"
python -m src.main algorithm=auto_qd env=bipedal_walker seed=$SEED algorithm.embedding.dim=100 logging.tags="['ablation', 'emb_dim100']" logging.group="ablation"
python -m src.main algorithm=auto_qd env=bipedal_walker seed=$SEED algorithm.embedding.dim=500 logging.tags="['ablation', 'emb_dim500']" logging.group="ablation"
python -m src.main algorithm=auto_qd env=bipedal_walker seed=$SEED algorithm.embedding.dim=1000 logging.tags="['ablation', 'emb_dim1000']" logging.group="ablation"