#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Fri Sep 25 16:23:00 2020

"""
import numpy as np
def distance_to_minimum(results,targetdataset,split,dataset,csv=True):
    # get predicted performance on datsaet pos
    # select the top 50 predictions
    suggestions = np.argsort(np.asarray(results['targetresponse']))[::-1] if csv else results
    # find the actual surrogate
    response = dataset.orig_surr[split][targetdataset][:,0]
    # get optimal value
    optimum = max(response)
    # evaluate selected predictions
    response = [response[_] for _ in suggestions]
    # estimate regret
    regret = optimum-response
    # define placeholder(s)
    incumbent = regret[0]
    # iterate over regret values
    output = []
    for _ in regret:
        # check current vs incumbent
        if _<incumbent:
            # assign incumbent to current
            incumbent = _
        # append incumbent to results
        output.append(incumbent)
    # return results
    return output