## Gradient Flow
```
cd gradient_flow
```
```
python3 main.py --d_func stsw --ntrees 200 --nlines 5 --lr 0.01 --epochs 500 --batch_size 2400 --ntry 10 --device cuda
```

## Self Supervised Learning
```
cd ssl
```
### d = 9
```
python3 train_eval.py --method stsw --num_trees 200 --num_lines 10 --unif_w 10 --feat_dim 10 --epochs 200 --batch_size 512 --momentum 0.9 --weight_decay 1e-3 --lr 0.05 --gpu 0
```
### d = 2
```
python3 train_eval.py --method stsw --num_trees 200 --num_lines 10 --unif_w 10 --feat_dim 3 --epochs 200 --batch_size 512 --momentum 0.9 --weight_decay 1e-3 --lr 0.05 --gpu 0
```

## Sliced Wasserstein Auto-Encoder
```
cd swae
```
```
python3 main.py --type swae --loss1 BCE --loss2 stsw --ntrees 200 --nlines 10 --beta 1 --d 3 --lr 1e-3 --epochs 100 --dataset c10 --prior vmf --batch_size 500 --device cuda
```

## Earth Density Estimation
```
cd density_estimation
```
### Earthquake
```
python3 train.py --loss stsw --dataset quakes_all --n_epochs 10000 --lr 0.05 \
--ntrees 1000 --nlines 100 --delta -100 --device cuda --pbar \
--n_blocks 48 --n_components 100 --n_try 5 
```
### Flood
```
python3 train.py --loss stsw --dataset flood --n_epochs 10000 --lr 0.05 \
--ntrees 1000 --nlines 100 --delta -100 --device cuda --pbar \
--n_blocks 48 --n_components 100 --n_try 5 
```
### Fire
```
python3 train.py --loss stsw --dataset fire --n_epochs 10000 --lr 0.05 \
--ntrees 1000 --nlines 100 --delta -100 --device cuda --pbar \
--n_blocks 48 --n_components 100 --n_try 5 
```

## Acknowledgment
The code is largely based on [s3wd](https://github.com/mint-vu/s3wd/tree/main)