import numpy as np

from numpy import linalg
from MarkovChains.MarkovChain import MarkovChain


def generate_cyclic_mc(num_states=50, num_dimensions=100, seed=777, cov_eigengap_threshold=10):
    np.random.seed(seed)
    cov_eigengap = -1
    markov_chain = None

    # while abs(cov_eigengap - cov_eigengap_threshold) < 10:
    transition_matrix = np.zeros((num_states, num_states))
    for i in range(num_states):
        x = np.random.uniform(0, 1)
        y = np.random.uniform(0, 1)
        z = np.random.uniform(0, 1)
        normalising_constant = (x + y + z)
        x /= normalising_constant
        y /= normalising_constant
        z /= normalising_constant
        # x = 0.1
        # y = 0.4
        # z = 0.5
        transition_matrix[i][i] = x
        transition_matrix[i][(i - 1) % num_states] = y
        transition_matrix[i][(i + 1) % num_states] = z

    means = np.zeros((num_states, num_dimensions))

    # covariance_matrices = []
    # for i in range(num_states):
    #     v_i = np.random.randn(num_dimensions)
    #     cov_i = np.outer(v_i, v_i)
    #     assert ((cov_i == np.transpose(cov_i)).all())
    #     covariance_matrices.append(cov_i)
    # covariance_matrices = np.array(covariance_matrices)

    # covariance_matrices = []
    # for i in range(num_states):
    #     V = []
    #     for j in range(num_states):
    #         v_i = np.random.randn(num_dimensions)
    #         v_i /= linalg.norm(v_i)
    #         V.append(v_i)
    #     V = np.transpose(np.array(V))
    #     t = np.ones(num_states)
    #     if i == 0:
    #         t[0] = 2500
    #     E = np.diag(t)
    #     cov_i = np.matmul(np.matmul(V, E), np.transpose(V))
    #     cov_i = (cov_i + np.transpose(cov_i)) / 2
    #     assert ((cov_i == np.transpose(cov_i)).all())
    #     covariance_matrices.append(cov_i)

    covariance_matrices = []
    for i in range(num_states):
        cov_i = np.zeros((num_dimensions, num_dimensions))
        c = np.random.uniform(1, 10)
        beta = np.random.uniform(1, 10)
        for x in range(num_dimensions):
            for y in range(num_dimensions):
                cov_i[x, y] = np.exp(-abs(x - y) * c) * (5 * np.power(x + 1, -beta)) * (5 * np.power(y + 1, -beta))
        cov_i = (cov_i + np.transpose(cov_i)) / 2
        assert ((cov_i == np.transpose(cov_i)).all())
        covariance_matrices.append(cov_i)

    initial_distribution = abs(np.random.randn(num_states))
    initial_distribution /= np.sum(initial_distribution)
    markov_chain = MarkovChain(transition_matrix=transition_matrix,
                               means=means,
                               covariance_matrices=covariance_matrices,
                               initial_distribution=initial_distribution,
                               seed=seed)

    cov_eigengap = markov_chain.cov_eigengap

    markov_chain.print()
    return markov_chain
