import numpy as np

from numpy import linalg
from MarkovChains.MarkovChain import MarkovChain


def generate_faulty_server_mc(num_states=2, num_dimensions=100, seed=777):
    # Check that the number of states is 2
    assert(num_states == 2)

    np.random.seed(seed)

    transition_matrix = np.array([[0.5, 0.5],
                                  [0.05, 0.95]])

    means = np.zeros((num_states, num_dimensions))

    covariance_matrices = []
    k = 50
    for i in range(num_states):
        V = []
        for j in range(k):
            v_i = np.random.randn(num_dimensions)
            v_i /= linalg.norm(v_i)
            V.append(v_i)
        V = np.transpose(np.array(V))
        t = np.ones(k)
        t[0] = 5
        E = np.diag(t)
        cov_i = np.matmul(np.matmul(V, E), np.transpose(V))
        cov_i = (cov_i + np.transpose(cov_i)) / 2
        assert ((cov_i == np.transpose(cov_i)).all())
        covariance_matrices.append(cov_i)

    initial_distribution = abs(np.random.randn(num_states))
    initial_distribution /= np.sum(initial_distribution)

    markov_chain = MarkovChain(transition_matrix=transition_matrix,
                               means=means,
                               covariance_matrices=covariance_matrices,
                               initial_distribution=initial_distribution,
                               seed=seed)

    markov_chain.print()
    return markov_chain
