import os
import pickle
import matplotlib.pyplot as plt

from matplotlib.pyplot import figure


def plot_and_save(experiment_name, output_dir, results, transition_eigengap, cov_eigengap):
    figure(figsize=(20, 12), dpi=100)
    plt.figure()
    with open('results/algorithm_comparison/data_drop_lambda_star_500-2022-09-27-7errors.csv', 'rb') as fp:
        errors_1 = pickle.load(fp)
    with open('results/algorithm_comparison/data_drop_lambda_star_500-2022-09-27-7indices.csv', 'rb') as fp:
        indices_1 = pickle.load(fp)
    with open('results/algorithm_comparison/data_drop_lambda_star_1000-2022-09-27-7errors.csv', 'rb') as fp:
        errors_2 = pickle.load(fp)
    with open('results/algorithm_comparison/data_drop_lambda_star_1000-2022-09-27-7indices.csv', 'rb') as fp:
        indices_2 = pickle.load(fp)
    with open('results/algorithm_comparison/data_drop_lambda_star_5000-2022-09-27-7errors.csv', 'rb') as fp:
        errors_3 = pickle.load(fp)
    with open('results/algorithm_comparison/data_drop_lambda_star_5000-2022-09-27-7indices.csv', 'rb') as fp:
        indices_3 = pickle.load(fp)
    plt.title("Comparison of Data Drop for varying lambda_star")
    plt.text(1, 1, 'Transition Eigengap : ' + str(round(transition_eigengap, 3)))
    plt.text(0.95, 0.95, 'Cov Eigengap : ' + str(round(cov_eigengap, 3)))
    plt.xlabel("Num Samples")
    plt.ylabel("Sine-squared error")
    plt.plot(indices_1, errors_1, label="lambda_star = 500, lambda_1 = 50")
    plt.plot(indices_2, errors_2, label="lambda_star = 1000, lambda_1 = 100")
    plt.plot(indices_3, errors_3, label="lambda_star = 5000, lambda_1 = 500")
    plt.legend()
    if not os.path.exists("./" + output_dir):
        os.makedirs("./" + output_dir)
    filename = output_dir + "/" + experiment_name + ".png"
    plt.savefig(filename)


plot_and_save("data_drop_comparison", "results/algorithm_comparison", None, 0.17188470506254916, 50.1273)
