from math import log10, floor

import os
import numpy as np
import pickle
import matplotlib.pyplot as plt
plt.rcParams.update({'font.size': 22})

def round_to_3(x):
    return round(x, -int(floor(log10(abs(x))) + (3 - 1)))

from matplotlib.pyplot import figure


def special_round(x, sig):
    return round(x, sig - int(floor(log10(abs(x)))) - 1)

def plot_and_save(experiment_name, output_dir, results, markov_chains):

    if not os.path.exists("./" + output_dir):
        os.makedirs("./" + output_dir)

    figure(figsize=(15, 12), dpi=100)

    # Plot experiement results
    plt.figure(1)
    plt.grid(True)

    colour_list = ['blue', 'green', 'red', 'magenta', 'cyan']
    linestyle_list = [':','--','-','-.','-']
    itr = 0
    lambda_unicode = '\u03BB'  # Unicode for the Greek letter lambda
    subscript_2 = '\u2082'  # Unicode for subscript 2
    lambda_2_map = ["1 - 5e-1", "1 - 5e-3", "1 - 1e-3", "1 - 5e-4"]
    for key in results:
        filename1 = output_dir + "/" + experiment_name + "_" + key + "_errors.csv"
        filename2 = output_dir + "/" + experiment_name + "_" + key + "_indices.csv"
        with open(filename1, 'wb') as fp:
            pickle.dump(results[key][0], fp)
        with open(filename2, 'wb') as fp:
            pickle.dump(results[key][1], fp)
        print(key, ", Number of indices : ", len(results[key][1]), ". Number of error values : ", len(results[key][0]))
        print(key, " initial error : ", results[key][0][0])
        print(key, " final error : ",  results[key][0][-1])
        # lambda2 = abs(1-markov_chains[key].transition_eigengap)
        lambda2 = lambda_2_map[itr]
        if lambda2 == 0:
            lambda2 = 1e-5
        # l = lambda_unicode + subscript_2 + " = " + str(special_round(lambda2, 3))
        l = "|" + lambda_unicode + subscript_2 + "(P)|" + " = " + lambda2
        plt.plot(results[key][1], results[key][0], label=l, linestyle=linestyle_list[itr], color=colour_list[itr], linewidth=3)
        itr+=1

    plt.xticks(fontweight='bold')
    plt.yticks(fontweight='bold')
    # plt.rcParams["text.usetex"] = True
    # plt.rcParams["text.latex.preamble"] = r"\usepackage{amsmath}"
    # plt.rcParams["text.latex.preamble"] = r"\usepackage{bm}"
    # plt.title('sin² error vs Number of Samples',fontweight='bold',fontsize=30)
    # plt.text(1, 1, 'Transition Eigengap : ' + str(round(transition_eigengap, 3)))
    # plt.text(0.95, 0.95, 'Cov Eigengap : ' + str(round(cov_eigengap, 3)))
    # plt.text(0.90, 0.90, 'Num states : ' + str(num_states))
    # plt.xlabel("Number of Samples",fontsize=30)
    # plt.ylabel('sin² error',fontsize=30)
    legend = plt.legend(fontsize=25)
    plt.setp(legend.get_texts())
    filename = output_dir + "/" + experiment_name + ".png"
    plt.savefig(filename)

    # # Plot eigenvalues of Covariance Matrix
    # plt.figure(2)
    # plt.title("Eigenvalues of Covariance Matrix")
    # plt.xlabel("Index")
    # plt.ylabel("Eigenvalue")
    # plt.plot(eigenvalues)
    # filename = output_dir + "/" + experiment_name + "_eigenvalues" + ".png"
    # plt.savefig(filename)
