import ml_collections


def get_config():
    config = ml_collections.ConfigDict()

    config.model_cls = "PixelBCLearner"

    config.actor_lr = 3e-4

    config.hidden_dims = (256, 256)

    config.cnn_features = (32, 64, 128, 256)
    config.cnn_filters = (3, 3, 3, 3)
    config.cnn_strides = (2, 2, 2, 2)
    config.cnn_padding = "VALID"
    config.latent_dim = 50
    config.encoder = "d4pg"

    config.cosine_decay = True
    config.use_layer_norm = False
    config.dropout_rate = 0.1

    return config
