import subprocess

import dmcgym


def test_online_dmc_sac():
    """Check that a D4RL gym run completes with no errors."""
    command = [
        "python",
        "examples/states/train_online.py",
        "--env_name",
        "cheetah-run-v0",
        "--config",
        "examples/states/configs/sac_config.py",
        "--max_steps",
        "110",
        "--start_training",
        "50",
        "--batch_size",
        "32",
        "--eval_interval",
        "100",
        "--eval_episodes",
        "1",
        "--config.hidden_dims",
        "(32, 32)",
    ]
    subprocess.run(command, check=True)


def test_online_dmc_td3():
    """Check that a D4RL gym run completes with no errors."""
    command = [
        "python",
        "examples/states/train_online.py",
        "--env_name",
        "cheetah-run-v0",
        "--config",
        "examples/states/configs/td3_config.py",
        "--max_steps",
        "110",
        "--start_training",
        "50",
        "--batch_size",
        "32",
        "--eval_interval",
        "100",
        "--eval_episodes",
        "1",
        "--config.hidden_dims",
        "(32, 32)",
    ]
    subprocess.run(command, check=True)


def test_online_dmc_video():
    """Check that a D4RL gym run completes with no errors."""
    command = [
        "python",
        "examples/states/train_online.py",
        "--env_name",
        "cheetah-run-v0",
        "--config",
        "examples/states/configs/td3_config.py",
        "--max_steps",
        "110",
        "--start_training",
        "50",
        "--batch_size",
        "32",
        "--eval_interval",
        "100",
        "--eval_episodes",
        "1",
        "--config.hidden_dims",
        "(32, 32)",
        "--save_video",
    ]
    subprocess.run(command, check=True)


def test_drq_dmc():
    """Check that a D4RL gym run completes with no errors."""
    command = [
        "python",
        "examples/pixels/train_online_pixels.py",
        "--env_name",
        "cheetah-run-v0",
        "--config",
        "examples/pixels/configs/drq_config.py",
        "--max_steps",
        "210",
        "--action_repeat",
        "2",
        "--start_training",
        "90",
        "--eval_interval",
        "100",
        "--batch_size",
        "32",
        "--eval_episodes",
        "1",
        "--config.hidden_dims",
        "(32, 32)",
        "--config.cnn_features",
        "(2, 4, 8, 16)",
    ]
    subprocess.run(command, check=True)
