
project="llm_verifier"
mem_size="80g"
ngpucores="2+1"
require="a100_80gb"
queue="x86_24h"
logs_dir=logs

scheduler="jbsub -proj $project -cores $ngpucores -mem $mem_size -require $require"

declare -a agent_types=("react_ablation" "react" "cot")
declare -a agent_types=("react_ablation" "react")
declare -a datasets=("fever_v1.0" "hotpot_qa")
model_name="mpt-7b-instruct"

for agent_type in "${agent_types[@]}"
do
    model_type="mosaicml/$model_name"
    for dataset in "${datasets[@]}"
    do
        if [ $dataset = "hotpot_qa" ]; then
            declare -a splits=("dev")
        else
            declare -a splits=("paper_dev")
        fi 

        for split in "${splits[@]}"
        do
            name_str="${dataset}_all_${model_name}_${agent_type}_${split}"
            $scheduler -queue $queue -name $name_str -out ${logs_dir}/${name_str}_log.txt \
                python -m src.evaluate \
                --model_type $model_type \
                --agent_type $agent_type \
                --dataset $dataset \
                --split $split \
                --few_shot_k 2 \
                --debug \
                --restart
        done
    done
done


