# Running shuffled iterative averaging aggregation with Keras CNN in IBM FL library

This example explains how to run federated learning using [shuffled iterative averaging aggregation](https://arxiv.org/pdf/2105.09400.pdf) on CNNs implemented with Keras training on
[MNIST](http://yann.lecun.com/exdb/mnist/) data. Data in this example is preprocessed by scaling down to range from `[0, 255]` to `[0, 1]`.
No other preprocessing is performed.

## Model Setup

This experiment can be run using models with different underlying framework. By default, configs with keras(tf 1.15) based model are generated, but other models like PYTORCH, Scikit Learn, keras(tf 2.1) can be created by changing -m param.


|       Model Type            |  Params   |
|:---------------------------:|:---------:|
|   Keras (with tf 1.15)      |  keras    |
|         Pytorch             |  pytorch  |
|        Scikit Learn         |  sklearn  |
|   Tensorflow/keras( tf 2.1) |  tf       |


## Dataset Setup
Shuffled Iterative Avg fusion can be run on different datasets by just changing -d param while generating config. Model definition changes as dataset changes, we currently only support below shown combinations.

|       Dataset      |  Params   |   Keras  |  Pytorch |    TF    |  sklearn |
|:------------------:|:--------: |:--------:|:--------:|:--------:|:--------:|
|        MNIST       |   mnist   |    YES   |    YES   |    YES   |    YES   |
|    Adult Dataset   |   adult   |     NO   |     NO   |     NO   |    YES   | 
|     Cifar-10       |  cifar10  |    YES   |     NO   |     NO   |     NO   |
|      FEMNIST       |  femnist  |    YES   |     NO   |     NO   |     NO   |


- Split data by running:
    ```
    python examples/generate_data.py -n <num_parties> -d <dataset> -pp <points_per_party>
    ```
- Generate config files by running:
    ```
    python examples/generate_configs.py -f shuffle_iter_avg -m keras -n <num_parties> -d <dataset> -p <path>
    ```
- Specify file path of permutation seed in the party_config:
    ```
    local_training:
        info:
            permute_secret: <seed_file>
    ```
- In a terminal running an activated IBM FL environment 
(refer to Quickstart in our website to learn more about how to set up the running environment), start the aggregator by running:
    ```
    python -m ibmfl.aggregator.aggregator <agg_config>
    ```
    Type `START` and press enter to start accepting connections
- In a terminal running an activated IBM FL environment, start each party by running:
    ```
    python -m ibmfl.party.party <party_config>
    ```
    Type `START` and press enter to start accepting connections.
    
    Type  `REGISTER` and press enter to register the party with the aggregator. 
- Finally, start training by entering `TRAIN` in the aggregator terminal.