import sys
import numpy
import torch

from importers.ea_ra_kgc import EaRaKgcData
from AlignKGC.alignkgc_base import get_base_argparser
from AlignKGC.AlignKGC_trainer import AlignKGC


def main(av):
    meta = EaRaKgcData(av.dbp5l)
    tr = AlignKGC(meta=meta, **(av.__dict__))
    if tr.eval_only:
        tr.do_eval_kgc_only()
    else:
        tr.start()


if __name__ == "__main__":
    parser = get_base_argparser()
    arguments = parser.parse_args()
    torch.manual_seed(arguments.seed)
    numpy.random.seed(arguments.seed)
    main(arguments)
