import sys
import numpy
import torch

from importers.ea_ra_kgc import EaRaKgcData
from AlignKGC.alignkgc_base import get_base_argparser
from AlignKGC import utils
from AlignKGC.Jaccard_trainer import Jaccard


def main(av):
    meta = EaRaKgcData(av.dbp5l)
    tr = Jaccard(meta=meta, **(av.__dict__))
    if tr.eval_only:
        tr.do_eval_kgc_only()
    else:
        tr.start()


if __name__ == "__main__":
    parser = get_base_argparser()
    arguments = parser.parse_args()
    torch.manual_seed(arguments.seed)
    numpy.random.seed(arguments.seed)
    if arguments.multiseed > 1:
        for seed in numpy.random.randint(10000, size=arguments.multiseed):
            arguments.seed = int(seed)
            torch.manual_seed(arguments.seed)
            numpy.random.seed(arguments.seed)
            main(arguments)
    else:
        main(arguments)
