import h5py

def concatenate_hdf5_files(file1, file2, output_file):
    """
    Concatenate two HDF5 files containing episode data into a single HDF5 file.
    Assumes no overlap in episode numbering between the two files.
    """
    with h5py.File(file1, 'r') as f1, h5py.File(file2, 'r') as f2, h5py.File(output_file, 'w') as out_file:
        # Copy all episodes from the first file
        for episode in f1.keys():
            f1.copy(episode, out_file)
        
        # Copy all episodes from the second file
        for episode in f2.keys():
            f2.copy(episode, out_file)

    print(f"Files {file1} and {file2} concatenated into {output_file}")
