import copy
import os
import os.path as osp
from diffusion_policy.dataset.robomimic_replay_image_dataset import _convert_actions
from diffusion_policy.model.common.rotation_transformer import RotationTransformer
import h5py
from tqdm import tqdm
import numpy as np

from diffusion_policy.common.replay_buffer import ReplayBuffer
from collect_square_exp_data import save_agentview_video

def create_replay_buffer(output, hdf5_file_path, string):
    with h5py.File(hdf5_file_path, 'r') as file:
        print('total sample ', file['data'].attrs["total"])
        demos = file['data']
        for i in tqdm(range(len(demos)), desc="Loading hdf5 to ReplayBuffer"):
            demo = demos[f'demo_{i}']
            agentview_images = list()
            eye_in_hand_images = list()
            for j in range(len(demo['actions'])):
                # print('shape demo[obs][agentview_image][j]', demo['obs']['agentview_image'][j].shape)
                agentview_images.append(demo['obs']['agentview_image'][j])
                eye_in_hand_images.append(demo['obs']['robot0_eye_in_hand_image'][j])

            video_path_view_1 = osp.join(f'visualizations/square/test_data_collection/{string}', 'episode_{}.mp4'.format(i))
            # video_path_view_2 = osp.join(f'visualizations/square/test_data_collection/{string}', 'episode_{}_view_2.mp4'.format(i))
            agentview_images = np.array(agentview_images)
            eye_in_hand_images = np.array(eye_in_hand_images)
            combined = np.concatenate((agentview_images, eye_in_hand_images), axis=1)
            # print('agentview_images shape ', agentview_images.shape)
            print('combined shape ', combined.shape)
            save_agentview_video(combined, video_path_view_1)
            # save_agentview_video(eye_in_hand_images, video_path_view_2)
